// exports.c

//4-5-98
//Some modifications and additions made by Chris Dohnal (cwdohnal@ucdavis.edu)

// Exports all of our unoverridden functions, and calls the originals which are loaded in imports.c

// Copr. 1998 - Justin Frankel/Nullsoft, Inc. (http://www.nullsoft.com)

#include <windows.h>
#define FX_GLIDE_NO_FUNC_PROTO
#include <glide.h>
#include <glideutl.h>
#include "pointers.h"

#define ENTRY __declspec(dllexport)
#define CALL __stdcall

VOID ErrorCallingFunction(LPCSTR);

/*
//Used for debug purposes
#define DOCALLI(func, parms)	{ \
	if (!_##func) MessageBox(NULL, "Error calling: _" #func, "Error in WinGlide", MB_OK | MB_ICONEXCLAMATION);	\
	else return _##func parms ; return 0; }

#define DOCALLF(func, parms)	{ \
	if (!_##func) MessageBox(NULL, "Error calling: _" #func, "Error in WinGlide", MB_OK | MB_ICONEXCLAMATION);	\
	else return _##func parms ; return 0.0f; }

#define DOCALL(func, parms)	{ \
	if (!_##func) MessageBox(NULL, "Error calling: _" #func, "Error in WinGlide", MB_OK | MB_ICONEXCLAMATION);	\
	else _##func parms ; }
*/
/*
#define DOCALLI(func, parms)	{ \
	return _##func parms; }

#define DOCALLF(func, parms)	{ \
	return _##func parms; }

#define DOCALL(func, parms)	{ \
	_##func parms; }
*/

/*
#define DOCALLI(func, parms)	{ \
	if (_##func != NULL) { return _##func parms; } \
	else { ErrorCallingFunction(#func); } \
	return 0; \
}

#define DOCALLF(func, parms)	{ \
	if (_##func != NULL) { return _##func parms; } \
	else { ErrorCallingFunction(#func); } \
	return 0; \
}

#define DOCALL(func, parms)	{ \
	if (_##func != NULL) { _##func parms; } \
	else { ErrorCallingFunction(#func); } \
	return; \
}
*/

#undef ENTRY
#define ENTRY __declspec(dllexport) __declspec(naked)
#define DOCALLI(func, parms)	{ \
	__asm jmp _##func \
}

#define DOCALLF(func, parms)	{ \
	__asm jmp _##func \
}

#define DOCALL(func, parms)	{ \
	__asm jmp _##func \
}


ENTRY FxU32 CALL grSstScreenHeight( void )
	DOCALLI(grSstScreenHeight,())
ENTRY FxU32 CALL grSstScreenWidth( void )
	DOCALLI(grSstScreenWidth,())
ENTRY void CALL grDrawLine( const GrVertex *v1, const GrVertex *v2 ) 
	DOCALL(grDrawLine,(v1,v2))
ENTRY void CALL grDrawPlanarPolygon( int nverts, const int ilist[], const GrVertex vlist[] )
	DOCALL(grDrawPlanarPolygon,(nverts,ilist,vlist))
ENTRY void CALL grDrawPlanarPolygonVertexList( int nverts, const GrVertex vlist[] )
	DOCALL(grDrawPlanarPolygonVertexList,(nverts,vlist))
ENTRY void CALL grDrawPoint( const GrVertex *pt ) 
	DOCALL(grDrawPoint,(pt))
ENTRY void CALL grDrawPolygon( int nverts, const int ilist[], const GrVertex vlist[] ) 
	DOCALL(grDrawPolygon,(nverts,ilist,vlist))
ENTRY void CALL grDrawPolygonVertexList( int nverts, const GrVertex vlist[] ) 
	DOCALL(grDrawPolygonVertexList,(nverts,vlist))
ENTRY void CALL grDrawTriangle( const GrVertex *a, const GrVertex *b, const GrVertex *c )
	DOCALL(grDrawTriangle,(a,b,c))
ENTRY void CALL grBufferClear( GrColor_t color, GrAlpha_t alpha, FxU16 depth )
	DOCALL(grBufferClear,(color,alpha,depth))
ENTRY int CALL grBufferNumPending( void )
	DOCALLI(grBufferNumPending,())
ENTRY void CALL grRenderBuffer( GrBuffer_t buffer ) 
	DOCALL(grRenderBuffer,(buffer))
typedef void (*GrErrorCallbackFnc_t)( const char *string, FxBool fatal );
ENTRY void CALL grErrorSetCallback( GrErrorCallbackFnc_t fnc )
	DOCALL(grErrorSetCallback,(fnc))
ENTRY void CALL grSstIdle(void)
	DOCALL(grSstIdle,())
ENTRY FxU32 CALL grSstVideoLine( void )
	DOCALLI(grSstVideoLine,())
ENTRY FxBool CALL grSstVRetraceOn( void )
	DOCALLI(grSstVRetraceOn,())
ENTRY FxBool CALL grSstIsBusy( void )
	DOCALLI(grSstIsBusy,())
ENTRY FxBool CALL grSstQueryHardware( GrHwConfiguration *hwconfig )
	DOCALLI(grSstQueryHardware,(hwconfig))
ENTRY FxBool CALL grSstQueryBoards( GrHwConfiguration *hwconfig )
	DOCALLI(grSstQueryBoards,(hwconfig))
ENTRY void CALL grSstOrigin(GrOriginLocation_t  origin)
	DOCALL(grSstOrigin,(origin))
ENTRY void CALL grSstSelect( int which_sst )
	DOCALL(grSstSelect,(which_sst))
ENTRY FxU32 CALL grSstStatus( void )
	DOCALLI(grSstStatus,())
ENTRY void CALL grSstPerfStats(GrSstPerfStats_t *pStats)
	DOCALL(grSstPerfStats,(pStats))
ENTRY void CALL grSstResetPerfStats(void)
	DOCALL(grSstResetPerfStats,())
ENTRY void CALL grResetTriStats()
	DOCALL(grResetTriStats,())
ENTRY void CALL grTriStats(FxU32 *trisProcessed, FxU32 *trisDrawn)
	DOCALL(grTriStats,(trisProcessed,trisDrawn))
ENTRY void CALL grAlphaBlendFunction(
                     GrAlphaBlendFnc_t rgb_sf,   GrAlphaBlendFnc_t rgb_df,
                     GrAlphaBlendFnc_t alpha_sf, GrAlphaBlendFnc_t alpha_df
                     )
	DOCALL(grAlphaBlendFunction,(rgb_sf,rgb_df,alpha_sf,alpha_df))
ENTRY void CALL grAlphaCombine(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert
               )
	DOCALL(grAlphaCombine,(function,factor,local,other,invert))
ENTRY void CALL grAlphaControlsITRGBLighting( FxBool enable )
	DOCALL(grAlphaControlsITRGBLighting,(enable))
ENTRY void CALL grAlphaTestFunction( GrCmpFnc_t function )
	DOCALL(grAlphaTestFunction,(function))
ENTRY void CALL grAlphaTestReferenceValue( GrAlpha_t value )
	DOCALL(grAlphaTestReferenceValue,(value))
ENTRY void CALL grChromakeyMode( GrChromakeyMode_t mode )
	DOCALL(grChromakeyMode,(mode))
ENTRY void CALL grChromakeyValue( GrColor_t value )
	DOCALL(grChromakeyValue,(value))
ENTRY void CALL grClipWindow( FxU32 minx, FxU32 miny, FxU32 maxx, FxU32 maxy )
	DOCALL(grClipWindow,(minx,miny,maxx,maxy))
ENTRY void CALL grColorCombine(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert )
	DOCALL(grColorCombine,(function,factor,local,other,invert))
ENTRY void CALL grColorMask( FxBool rgb, FxBool a )
	DOCALL(grColorMask,(rgb,a))
ENTRY void CALL grCullMode( GrCullMode_t mode )
	DOCALL(grCullMode,(mode))
ENTRY void CALL grConstantColorValue( GrColor_t value )
	DOCALL(grConstantColorValue,(value))
ENTRY void CALL grConstantColorValue4( float a, float r, float g, float b )
	DOCALL(grConstantColorValue4,(a,r,g,b))
ENTRY void CALL grDepthBiasLevel( FxI16 level )
	DOCALL(grDepthBiasLevel,(level))
ENTRY void CALL grDepthBufferFunction( GrCmpFnc_t function )
	DOCALL(grDepthBufferFunction,(function))
ENTRY void CALL grDepthBufferMode( GrDepthBufferMode_t mode )
	DOCALL(grDepthBufferMode,(mode))
ENTRY void CALL grDepthMask( FxBool mask )
	DOCALL(grDepthMask,(mask))
ENTRY void CALL grDisableAllEffects( void )
	DOCALL(grDisableAllEffects,())
ENTRY void CALL grDitherMode( GrDitherMode_t mode )
	DOCALL(grDitherMode,(mode))
ENTRY void CALL grFogColorValue( GrColor_t fogcolor )
	DOCALL(grFogColorValue,(fogcolor))
ENTRY void CALL grFogMode( GrFogMode_t mode )
	DOCALL(grFogMode,(mode))
ENTRY void CALL grFogTable( const GrFog_t ft[GR_FOG_TABLE_SIZE] )
	DOCALL(grFogTable,(ft))
ENTRY void CALL grGammaCorrectionValue( float value )
	DOCALL(grGammaCorrectionValue,(value))
ENTRY void CALL grSplash(float x, float y, float width, float height, FxU32 frame)
	DOCALL(grSplash,(x,y,width,height,frame))
ENTRY FxU32 CALL grTexCalcMemRequired(
                     GrLOD_t lodmin, GrLOD_t lodmax,
                     GrAspectRatio_t aspect, GrTextureFormat_t fmt
					 )
	DOCALLI(grTexCalcMemRequired,(lodmin,lodmax,aspect,fmt))
ENTRY FxU32 CALL grTexTextureMemRequired( FxU32     evenOdd, GrTexInfo *info   )
	DOCALLI(grTexTextureMemRequired,(evenOdd,info))
ENTRY FxU32 CALL grTexMinAddress( GrChipID_t tmu )
	DOCALLI(grTexMinAddress,(tmu))
ENTRY FxU32 CALL grTexMaxAddress( GrChipID_t tmu )
	DOCALLI(grTexMaxAddress,(tmu))
ENTRY void CALL grTexNCCTable( GrChipID_t tmu, GrNCCTable_t table )
	DOCALL(grTexNCCTable,(tmu,table))
ENTRY void CALL grTexSource( GrChipID_t tmu, FxU32      startAddress, FxU32      evenOdd, GrTexInfo  *info )
	DOCALL(grTexSource,(tmu,startAddress,evenOdd,info))
ENTRY void CALL grTexClampMode( 
			   GrChipID_t tmu,
               GrTextureClampMode_t s_clampmode,
               GrTextureClampMode_t t_clampmode
               )
	DOCALL(grTexClampMode,(tmu,s_clampmode,t_clampmode))
ENTRY void CALL grTexCombine(
             GrChipID_t tmu,
             GrCombineFunction_t rgb_function,
             GrCombineFactor_t rgb_factor, 
             GrCombineFunction_t alpha_function,
             GrCombineFactor_t alpha_factor,
             FxBool rgb_invert,
             FxBool alpha_invert
             )
	DOCALL(grTexCombine,(tmu,rgb_function,rgb_factor,alpha_function,alpha_factor,rgb_invert,alpha_invert))
ENTRY void CALL grTexCombineFunction(
                     GrChipID_t tmu,
                     GrTextureCombineFnc_t fnc
                     )
	DOCALL(grTexCombineFunction,(tmu,fnc))
ENTRY void CALL grTexDetailControl(
                   GrChipID_t tmu,
                   int lod_bias,
                   FxU8 detail_scale,
                   float detail_max
                   )
	DOCALL(grTexDetailControl,(tmu,lod_bias,detail_scale,detail_max))
ENTRY void CALL grTexFilterMode(
                GrChipID_t tmu,
                GrTextureFilterMode_t minfilter_mode,
                GrTextureFilterMode_t magfilter_mode
                )
	DOCALL(grTexFilterMode,(tmu,minfilter_mode,magfilter_mode))
ENTRY void CALL grTexLodBiasValue(GrChipID_t tmu, float bias )
	DOCALL(grTexLodBiasValue,(tmu,bias))
ENTRY void CALL grTexDownloadMipMap( GrChipID_t tmu,
                     FxU32      startAddress,
                     FxU32      evenOdd,
                     GrTexInfo  *info 
					 )
	DOCALL(grTexDownloadMipMap,(tmu,startAddress,evenOdd,info))
ENTRY void CALL grTexDownloadMipMapLevel( GrChipID_t        tmu,
                          FxU32             startAddress,
                          GrLOD_t           thisLod,
                          GrLOD_t           largeLod,
                          GrAspectRatio_t   aspectRatio,
                          GrTextureFormat_t format,
                          FxU32             evenOdd,
                          void              *data 
						  )
	DOCALL(grTexDownloadMipMapLevel,(tmu,startAddress,thisLod,largeLod,aspectRatio,format,evenOdd,data))
ENTRY void CALL grTexDownloadMipMapLevelPartial( GrChipID_t        tmu,
                                 FxU32             startAddress,
                                 GrLOD_t           thisLod,
                                 GrLOD_t           largeLod,
                                 GrAspectRatio_t   aspectRatio,
                                 GrTextureFormat_t format,
                                 FxU32             evenOdd,
                                 void              *data,
                                 int               start,
                                 int               end 
								 )
	DOCALL(grTexDownloadMipMapLevelPartial,(tmu,startAddress,thisLod,largeLod,aspectRatio,format,evenOdd,data,start,end))
ENTRY void CALL ConvertAndDownloadRle( GrChipID_t        tmu,
                        FxU32             startAddress,
                        GrLOD_t           thisLod,
                        GrLOD_t           largeLod,
                        GrAspectRatio_t   aspectRatio,
                        GrTextureFormat_t format,
                        FxU32             evenOdd,
                        FxU8              *bm_data,
                        long              bm_h,
                        FxU32             u0,
                        FxU32             v0,
                        FxU32             width,
                        FxU32             height,
                        FxU32             dest_width,
                        FxU32             dest_height,
                        FxU16             *tlut
						)
	DOCALL(ConvertAndDownloadRle,(tmu,startAddress,thisLod,largeLod,aspectRatio,format,evenOdd,bm_data,bm_h,u0,v0,width,height,dest_width,dest_height,tlut))
ENTRY void CALL grCheckForRoom(FxI32 n)
	DOCALL(grCheckForRoom,(n))
ENTRY void CALL	grTexDownloadTable( GrChipID_t   tmu,                    
									GrTexTable_t type, 
									void         *data 
									)
	DOCALL(grTexDownloadTable,(tmu,type,data))
ENTRY void CALL grTexDownloadTablePartial( GrChipID_t   tmu,
                           GrTexTable_t type, 
                           void         *data,
                           int          start,
                           int          end 
						   )
	DOCALL(grTexDownloadTablePartial,(tmu,type,data,start,end))
ENTRY void CALL grTexMipMapMode( GrChipID_t     tmu, 
                 GrMipMapMode_t mode,
                 FxBool         lodBlend 
				 )
	DOCALL(grTexMipMapMode,(tmu,mode,lodBlend))
ENTRY void CALL grTexMultibase( GrChipID_t tmu, FxBool     enable )
	DOCALL(grTexMultibase,(tmu,enable))
ENTRY void CALL grTexMultibaseAddress( GrChipID_t       tmu,
                       GrTexBaseRange_t range,
                       FxU32            startAddress,
                       FxU32            evenOdd,
                       GrTexInfo        *info 
					   )
	DOCALL(grTexMultibaseAddress,(tmu,range,startAddress,evenOdd,info))
ENTRY GrMipMapId_t CALL guTexAllocateMemory(
                    GrChipID_t tmu,
                    FxU8 odd_even_mask,
                    int width, int height,
                    GrTextureFormat_t fmt,
                    GrMipMapMode_t mm_mode,
                    GrLOD_t smallest_lod, GrLOD_t largest_lod,
                    GrAspectRatio_t aspect,
                    GrTextureClampMode_t s_clamp_mode,
                    GrTextureClampMode_t t_clamp_mode,
                    GrTextureFilterMode_t minfilter_mode,
                    GrTextureFilterMode_t magfilter_mode,
                    float lod_bias,
                    FxBool trilinear
                    )
	DOCALLI(guTexAllocateMemory,(tmu,odd_even_mask,width,height,fmt,mm_mode,smallest_lod,largest_lod,
								 aspect,s_clamp_mode,t_clamp_mode,minfilter_mode,magfilter_mode,lod_bias,trilinear))
ENTRY FxBool CALL guTexChangeAttributes(
                      GrMipMapId_t mmid,
                      int width, int height,
                      GrTextureFormat_t fmt,
                      GrMipMapMode_t mm_mode,
                      GrLOD_t smallest_lod, GrLOD_t largest_lod,
                      GrAspectRatio_t aspect,
                      GrTextureClampMode_t s_clamp_mode,
                      GrTextureClampMode_t t_clamp_mode,
                      GrTextureFilterMode_t minFilterMode,
                      GrTextureFilterMode_t magFilterMode
                      )
	DOCALLI(guTexChangeAttributes,(mmid,width,height,fmt,mm_mode,smallest_lod,largest_lod,aspect,s_clamp_mode,t_clamp_mode,minFilterMode,magFilterMode))
ENTRY void CALL guTexCombineFunction(
                     GrChipID_t tmu,
                     GrTextureCombineFnc_t fnc
                     )
	DOCALL(guTexCombineFunction,(tmu,fnc))
ENTRY GrMipMapId_t CALL guTexGetCurrentMipMap( GrChipID_t tmu )
	DOCALLI(guTexGetCurrentMipMap,(tmu))
ENTRY GrMipMapInfo * CALL guTexGetMipMapInfo( GrMipMapId_t mmid )
	DOCALLI(guTexGetMipMapInfo,(mmid))
ENTRY FxU32 CALL guTexMemQueryAvail( GrChipID_t tmu )
	DOCALLI(guTexMemQueryAvail,(tmu))
ENTRY void CALL guTexMemReset( void )
	DOCALL(guTexMemReset,())
ENTRY void CALL guTexDownloadMipMap(
                    GrMipMapId_t mmid,
                    const void *src,
                    const GuNccTable *table
                    )
	DOCALL(guTexDownloadMipMap,(mmid,src,table))
ENTRY void CALL guTexDownloadMipMapLevel(
                         GrMipMapId_t mmid,
                         GrLOD_t lod,
                         const void **src
                         )
	DOCALL(guTexDownloadMipMapLevel,(mmid,lod,src))
ENTRY void CALL guTexSource( GrMipMapId_t id )
	DOCALL(guTexSource,(id))
ENTRY FxBool CALL grLfbLock( GrLock_t type, GrBuffer_t buffer, GrLfbWriteMode_t writeMode,
							GrOriginLocation_t origin, FxBool pixelPipeline, 
							GrLfbInfo_t *info 
							)
	DOCALLI(grLfbLock,(type,buffer,writeMode,origin,pixelPipeline,info))
ENTRY FxBool CALL grLfbUnlock( GrLock_t type, GrBuffer_t buffer )
	DOCALLI(grLfbUnlock,(type,buffer))
ENTRY void CALL grLfbConstantAlpha( GrAlpha_t alpha )
	DOCALL(grLfbConstantAlpha,(alpha))
ENTRY void CALL grLfbConstantDepth( FxU16 depth )
	DOCALL(grLfbConstantDepth,(depth))
ENTRY void CALL grLfbWriteColorSwizzle(FxBool swizzleBytes, FxBool swapWords)
	DOCALL(grLfbWriteColorSwizzle,(swizzleBytes,swapWords))
ENTRY void CALL grLfbWriteColorFormat(GrColorFormat_t colorFormat)
	DOCALL(grLfbWriteColorFormat,(colorFormat))
ENTRY FxBool CALL grLfbWriteRegion( GrBuffer_t dst_buffer, 
                  FxU32 dst_x, FxU32 dst_y, 
                  GrLfbSrcFmt_t src_format, 
                  FxU32 src_width, FxU32 src_height, 
                  FxI32 src_stride, void *src_data 
				  )
	DOCALLI(grLfbWriteRegion,(dst_buffer,dst_x,dst_y,src_format,src_width,src_height,src_stride,src_data))
ENTRY FxBool CALL grLfbReadRegion( GrBuffer_t src_buffer,
                 FxU32 src_x, FxU32 src_y,
                 FxU32 src_width, FxU32 src_height,
                 FxU32 dst_stride, void *dst_data 
				 )
	DOCALLI(grLfbReadRegion,(src_buffer,src_x,src_y,src_width,src_height,dst_stride,dst_data))
ENTRY void CALL grAADrawLine(const GrVertex *v1, const GrVertex *v2)
	DOCALL(grAADrawLine,(v1,v2))
ENTRY void CALL grAADrawPoint(const GrVertex *pt )
	DOCALL(grAADrawPoint,(pt))
ENTRY void CALL grAADrawPolygon(const int nverts, const int ilist[], const GrVertex vlist[])
	DOCALL(grAADrawPolygon,(nverts,ilist,vlist))
ENTRY void CALL grAADrawPolygonVertexList(const int nverts, const GrVertex vlist[])
	DOCALL(grAADrawPolygonVertexList,(nverts,vlist))
ENTRY void CALL grAADrawTriangle(
                 const GrVertex *a, const GrVertex *b, const GrVertex *c,
                 FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
                 )
	DOCALL(grAADrawTriangle,(a,b,c,ab_antialias,bc_antialias,ca_antialias))
ENTRY void CALL grGlideInit( void )
	DOCALL(grGlideInit,())
ENTRY void CALL grGlideShutdown( void )
	DOCALL(grGlideShutdown,())
ENTRY void CALL grGlideGetVersion( char version[80] )
	DOCALL(grGlideGetVersion,(version))
ENTRY void CALL grGlideGetState( GrState *state )
	DOCALL(grGlideGetState,(state))
ENTRY void CALL grGlideSetState( const GrState *state )
	DOCALL(grGlideSetState,(state))
ENTRY void CALL grGlideShamelessPlug(const FxBool on)
	DOCALL(grGlideShamelessPlug,(on))
ENTRY void CALL grHints(GrHint_t hintType, FxU32 hintMask)
	DOCALL(grHints,(hintType,hintMask))
ENTRY void CALL guAADrawTriangleWithClip( const GrVertex *a, const GrVertex *b, const GrVertex *c)
	DOCALL(guAADrawTriangleWithClip,(a,b,c))
ENTRY void CALL	guDrawTriangleWithClip(const GrVertex *a, const GrVertex *b, const GrVertex *c)
	DOCALL(guDrawTriangleWithClip,(a,b,c))
ENTRY void CALL guDrawPolygonVertexListWithClip( int nverts, const GrVertex vlist[] )
	DOCALL(guDrawPolygonVertexListWithClip,(nverts,vlist))
ENTRY void CALL guAlphaSource( GrAlphaSource_t mode )
	DOCALL(guAlphaSource,(mode))
ENTRY void CALL guColorCombineFunction( GrColorCombineFnc_t fnc )
	DOCALL(guColorCombineFunction,(fnc))
ENTRY int CALL guEncodeRLE16( void *dst, 
               void *src, 
               FxU32 width, 
               FxU32 height 
			   )
	DOCALLI(guEncodeRLE16,(dst,src,width,height))
ENTRY FxU16 * CALL guTexCreateColorMipMap( void )
	DOCALLI(guTexCreateColorMipMap,())
ENTRY void CALL guMovieStart( void ) 
	DOCALL(guMovieStart,())
ENTRY void CALL guMovieStop( void )
	DOCALL(guMovieStop,())
ENTRY void CALL guMovieSetName( const char *name )
	DOCALL(guMovieSetName,(name))
ENTRY float CALL guFogTableIndexToW( int i )
	DOCALLF(guFogTableIndexToW,(i))
ENTRY void CALL guFogGenerateExp( GrFog_t fogtable[GR_FOG_TABLE_SIZE], float density )
	DOCALL(guFogGenerateExp,(fogtable,density))
ENTRY void CALL guFogGenerateExp2( GrFog_t fogtable[GR_FOG_TABLE_SIZE], float density )
	DOCALL(guFogGenerateExp2,(fogtable,density))
ENTRY void CALL guFogGenerateLinear(
					GrFog_t fogtable[GR_FOG_TABLE_SIZE],
                    float nearZ, float farZ 
					)
	DOCALL(guFogGenerateLinear,(fogtable,nearZ,farZ))
ENTRY FxU32 CALL guEndianSwapWords( FxU32 value )
	DOCALLI(guEndianSwapWords,(value))
ENTRY FxU16 CALL guEndianSwapBytes( FxU16 value )
	DOCALLI(guEndianSwapBytes,(value))
ENTRY FxBool CALL gu3dfGetInfo( const char *filename, Gu3dfInfo *info )
	DOCALLI(gu3dfGetInfo,(filename,info))
ENTRY FxBool CALL gu3dfLoad( const char *filename, Gu3dfInfo *data )
	DOCALLI(gu3dfLoad,(filename,data))


VOID ErrorCallingFunction(LPCSTR szName) {
	#define MAX_NAME_LEN	64
	static char szErrorCalling[] = "Error calling: _";
	char szMessage[MAX_NAME_LEN + sizeof(szErrorCalling)];

	lstrcpy(szMessage, szErrorCalling);
	lstrcat(szMessage, szName);
	MessageBox(NULL, szMessage, "Error in WinGlide", MB_OK | MB_ICONSTOP);
	return;
}
